# _*_ coding: UTF-8 _*_
"""
@Author: zzz
@Date: 2025/8/7 16:00
此智能体为强化学习智能体示例中护航战斗机的规则智能体，采用规则方式设置护航巡逻任务；
未指定型号和数量，战斗机类型的飞机均可，一般考虑三架护航战斗机
动作空间为：

"""

import logging

from engine.LingYi.entitys.global_util import *
from engine.LingYi.entitys.agent_base import RuleAgentBase


class Agent(RuleAgentBase):
    def __init__(self, side_name, params):
        RuleAgentBase.__init__(self, side_name)
        logging.info('%s:%s play game' % (side_name, self.__class__.__name__))
        self.escort_mission_name = None
        self.check_is_done = None
        self.sentry_id = None
        self.first_in = True
        self.time_initial = 0

    def initial(self, situation):
        """
        初始化函数，每局推演开始前被调用. 可用于任务创建、设置，条令设置，变量初始化等
        :param situation: tuple: units, contacts
        :return:
        """
        unit_guid = [unit['guid'] for unit in situation[0].values() if
                     unit['name'] == 'A-100 Premier 预警机 [伊尔-476] #1']
        self.sentry_id = unit_guid[0]
        # 创建空战巡逻任务，
        self.escort_mission_name = 'escort'
        if self.escort_mission_name not in self.missions_obj.keys():
            self.create_air_escort_mission(situation)

        # 设置飞机单机出动
        if len(self.client_info['unit']) > 0:
            select_units_guid = list(self.client_info['unit'].keys())  # 客户端选择的单元对象id
            self.crt_select_airs = set(select_units_guid)
            self.assign_units_to_mission(select_units_guid, self.escort_mission_name)  # 分配任务
            self.air_single_out(select_units_guid)  # 飞机起飞

    def step(self, time_elapse, situation):
        """
        # 每步决策函数
        :param time_elapse:  int, time elapse
        :param situation: tuple: units-list, contacts-list
        :return:
        """
        # 判断预警机是否存活，再决定飞机的巡逻区域，每个180秒更新一次巡逻区域
        if self.first_in:
            self.time_initial = time_elapse
            self.first_in = False

        if self.sentry_id in situation[0].keys() :  # and (time_elapse-self.time_initial) % 180 == 0 and (time_elapse!=self.time_initial)
            patrol_area = self.create_air_escort_area()
            if patrol_area is not None:
                for point in patrol_area:
                    p_name = point[2]
                    new_cor = (point[0],point[1])
                    self.reference_point_move(p_name,new_cor)

            # 设置飞机单机出动
            if len(self.client_info['unit']) > 0:
                select_units_guid = list(self.client_info['unit'].keys())  # 客户端选择的单元对象id
                new_add_air = list(set(select_units_guid)-set(self.crt_select_airs))
                self.crt_select_airs = set(select_units_guid)

            # 判断所选飞机是否还存活
            exist_unit = list(set(self.crt_select_airs) & set(situation[0].keys()))
            if not exist_unit:
                self.check_is_done = True
                return

            if new_add_air is not None:
                self.assign_units_to_mission(new_add_air, self.escort_mission_name)  # 分配任务
                self.air_single_out(new_add_air)  # 飞机起飞

    def deduction_end(self):
        # agent结束后自动被调用函数， 可保存模型，比如记录本局策略后的得分等
        logging.info('%s:%s play game result:%d' % (self.Name, self.__class__.__name__, self.TotalScore))

    def is_done(self):
        # agent主动结束本局推演，比如一定胜利或失败后
        # 只能训练时调用此函数，比赛对战时此函数不可用
        if self.check_is_done:
            return True
        return False

    def create_air_escort_mission(self, situation):
        """
        智能体选择的空中飞机，可获取中心位置，则创建巡逻任务；
        设置巡逻任务
        :param situation: dict, 态势
        :return: tuple, (lat, lon), 纬度、经度元组
        """
        patrol_area = self.create_air_escort_area()
        if patrol_area is not None:
            # 创建巡逻任务
            self.patrol_mission = self.create_patrol_mission(self.escort_mission_name, MissionPatrolType.AIR,
                                                             patrol_area)
            # 任务设置
            self.patrol_mission.patrol_flight_size(FlightSize.One)  # 任务战斗机单机编队
            self.patrol_mission.patrol_checkOPA(False)  # 对巡逻区外的探测目标进行分析
            # 巡逻任务设置条令
            self.patrol_mission.doctrine_ignore_plotted_course(IgnorePlottedCourseWhenAttacking.Yes)  # 攻击时忽略计划航线
            self.patrol_mission.doctrine_weapon_control_status_air(WeaponControlStatus.Tight)  # 对空谨慎开火
            self.patrol_mission.set_one_third_rule(False)  # 所有飞机起飞
            self.patrol_mission.doctrine_automatic_evasion(AutomaticEvasion.Yes)  # 自动规避
            self.patrol_mission.doctrine_fuel_state_planned(FuelState.Bingo)  # 到燃油状态预先规划
            self.patrol_mission.doctrine_fuel_state_rtb(FuelStateRTB.YesLeaveGroup)  # 到燃油状态返航
            # 不使用航炮
            self.patrol_mission.doctrine_weapon_state_planned(WeaponStatePlanned.ShotgunOneEngageStrikeNoAirguns)
            # 武器状态返航设置
            self.patrol_mission.doctrine_weapon_state_rtb(WeaponStateRTB.YesLeaveGroup)

    def create_air_escort_area(self):
        patrol_area = []
        sentry = self.get_unit(self.sentry_id)
        lat, lon = sentry.Lat, sentry.Lon
        if lat is not None:
            east_lon = lon + 1
            if east_lon > 180:
                # 西经
                east_lon -= 360
            west_lon = lon - 1
            if west_lon < -180:
                # 西经变东经了
                west_lon += 360
            up_lat = lat + 1
            if up_lat > 89.99999:
                up_lat = 89.99999
            down_lat = lat - 1
            if down_lat < -89.99999:
                down_lat = -89.99999
            patrol_area = [(up_lat, west_lon, 'ES_P1'), (up_lat, east_lon, 'ES_P2'),
                           (down_lat, east_lon, 'ES_P3'), (down_lat, west_lon, 'ES_P4')]

        return patrol_area
