# -*- coding:utf-8 -*-
# Author: MouQingPing/WuRuiZhuo

"""
蓝方初赛AI版（改进版）.scen
添加红方任务 共11个具体如下：
1、共5个巡逻任务：o_patrol/MI_23_patrol/MI_29_patrol/Su_75_patrol/T50_patrol
2、打击任务：ShiZong_attack
3、共5个支援任务：YiEr_78_support/A100_support/A50_support/A100_support/S100B_support
"""

from engine.LingYi.entitys.global_util import *
from engine.LingYi.entitys.player import Player


class Agent(Player):
    def __init__(self, side_name, params):
        Player.__init__(self, side_name)
        super(Agent, self).__init__(side_name)

    def initial(self, situation):
        """
        初始化函数，每局推演开始前被调用. 可用于任务创建、设置，条令设置，变量初始化等
        :param situation: tuple: units, contacts
        :return:
        """
        situation_data = situation[0] if isinstance(situation[0], dict) else []

        # 巡逻任务
        self.create_patrol_mission(name='o_patrol', mission_type=MissionPatrolType.AIR,
                                   point_list=[(22.3, -87.1), (22.3, -83.6), (20.9, -83.6), (20.9, -87.1)])
        o_patrol = self.get_mission_by_name('o_patrol')
        unit_names = {'苏-33型 #1', '苏-33型 #2', '苏-33型 #3',
                          '米格-29K型 #1', '米格-29K型 #2', '米格-29K型 #3', '米格-29K型 #4',
                          'EF2000 型 #1', 'EF2000 型 #2', 'EF2000 型 #3', 'EF2000 型 #4', 'EF2000 型 #5',
                          '苏-30SM“侧卫G”战斗机 #5', '苏-30SM“侧卫G”战斗机 #6', '苏-30SM“侧卫G”战斗机 #7', '苏-30SM“侧卫G”战斗机 #8',
                          '苏-35S型 #4', '苏-35S型 #5', '苏-35S型 #6'}
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='o_patrol', unit_list=unit_guid_list[0:10])#注意：这里assign_units_to_mission将单元拆分两次下发，因为平台设置下发指令长度不超过300
        self.assign_units_to_mission(mission_name='o_patrol', unit_list=unit_guid_list[10:])
        o_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模 2机编队，常用于战斗机
        o_patrol.set_flightStoengage('all')  # 敌方对抗的飞机数量 所有飞机编队出动
        o_patrol.set_wingmanEngageDistance(5)  #飞机设置  僚机可以在xx范围内侦察/交战   海里
        o_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞 否

        o_patrol.station_count(0)  # 为保持阵位的数量 0
        o_patrol.set_one_third_rule(False)  # 三分之一规则 不开启
        o_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析 不开启
        o_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析 开启
        o_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射  不开启

        o_patrol.patrol_set_throttle_transit(Throttle.Full)  # 设置任务的出航油门 军用
        o_patrol.patrol_set_throttle_station(Throttle.Full)  # 设置任务的阵位油门 军用
        o_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门 不定
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='MI_23_patrol', mission_type=MissionPatrolType.AIR,
                                   point_list=[(18.288, -91.908), (18.257, -91.434), (17.638, -91.6545),(17.686, -91.956)])
        MI_23_patrol = self.get_mission_by_name('MI_23_patrol')
        unit_names = {'米格-23ML“鞭挞者”战斗机  #1', '米格-23ML“鞭挞者”战斗机  #2', '米格-23ML“鞭挞者”战斗机  #3',
                      '米格-21bis型 #1','米格-21bis型 #2'}
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='MI_23_patrol', unit_list=unit_guid_list)
        MI_23_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模  2机编队，常用于战斗机
        MI_23_patrol.set_flightStoengage('all')  # 敌方对抗的飞机数量  所有飞机编队出动
        MI_23_patrol.set_wingmanEngageDistance(200) #飞机设置  僚机可以在xx范围内侦察/交战   海里
        MI_23_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞 否

        MI_23_patrol.station_count(0)  # 为保持阵位的数量 0
        MI_23_patrol.set_one_third_rule(False)  # 三分之一规则 不开启
        MI_23_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析 不开启
        MI_23_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析 开启
        MI_23_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析 开启
        MI_23_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射 不开启

        MI_23_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门 巡航
        MI_23_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门 低速
        MI_23_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门 不定
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='MI_29_patrol', mission_type=MissionPatrolType.AIR,
                                   point_list=[(18.602, -93.131), (18.588, -92.069), (16.625, -92.202),(16.609, -93.197)])
        MI_29_patrol = self.get_mission_by_name('MI_29_patrol')
        unit_names = {'米格-29型 #1', '米格-29型 #2', '米格-29型 #3',
                      '米格-29型 #4','米格-29型 #5', '米格-29型 #6'}
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='MI_29_patrol', unit_list=unit_guid_list)
        MI_29_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模  2机编队，常用于战斗机
        MI_29_patrol.set_flightStoengage('all')  # 敌方对抗的飞机数量  所有飞机编队出动
        MI_29_patrol.set_wingmanEngageDistance(300) #飞机设置  僚机可以在xx范围内侦察/交战   海里
        MI_29_patrol.patrol_useFlightSize(True)  # 是否飞机数低于编队规模不允许起飞 否

        MI_29_patrol.station_count(0)  # 为保持阵位的数量 0
        MI_29_patrol.set_one_third_rule(False)  # 三分之一规则 不开启
        MI_29_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析 不开启
        MI_29_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析 开启
        MI_29_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射 不开启

        MI_29_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门  巡航
        MI_29_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门 低速
        MI_29_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门 不定
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='Su_75_patrol', mission_type=MissionPatrolType.AIR,
                                   point_list=[(20.0, -92.5), (21.6, -88.0), (20.0, -87.2), (18.7, -92.4)])
        su_75_patrol = self.get_mission_by_name('Su_75_patrol')
        unit_names = {'Su-75 Checkmate 战斗机 #1', 'Su-75 Checkmate 战斗机 #2', 'Su-75 Checkmate 战斗机 #3',
                          # 'Su-75 Checkmate 战斗机 #4', 'Su-75 Checkmate 战斗机 #5', 'Su-75 Checkmate 战斗机 #6',
                          # 'Su-75 Checkmate 战斗机 #7', 'Su-75 Checkmate 战斗机 #8', 'Su-75 Checkmate 战斗机 #9',
                          'A-100 Premier 预警机 [伊尔-476] #1'} #3*架Su-75 Checkmate 战斗机 + A-100 Premier
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='Su_75_patrol', unit_list=unit_guid_list)
        su_75_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模  2机编队，常用于战斗机
        su_75_patrol.set_flightStoengage('3')  # 敌方对抗的飞机数量 3机编组
        su_75_patrol.patrol_useFlightSize(True)  # 是否飞机数低于编队规模不允许起飞 是
        su_75_patrol.set_wingmanEngageDistance(300) #飞机设置  僚机可以在xx范围内侦察/交战   海里

        su_75_patrol.station_count(0)  # 为保持阵位的数量 0
        su_75_patrol.set_one_third_rule(False)  # 三分之一规则 不开启
        su_75_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析 不开启
        su_75_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析 开启
        su_75_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射 不开启

        su_75_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门 巡航
        su_75_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门 低速
        su_75_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门 不定
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='T50_patrol', mission_type=MissionPatrolType.AIR,
                                   point_list=[(19.1, -95.4), (18.9, -93.132), (16.2, -93.2), (16.2, -95.7)])
        t_50_patrol = self.get_mission_by_name('T50_patrol')
        unit_names = {'T-50型 #1', 'T-50型 #2', 'T-50型 #3', 'T-50型 #4',
                          '图-214R型 #1',
                          '米格-31BM型“猎狐”战斗机#1', '米格-31BM型“猎狐”战斗机#2', '米格-35型 #2'}
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='T50_patrol', unit_list=unit_guid_list)
        t_50_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模  2机编队，常用于战斗机
        t_50_patrol.set_flightStoengage('3')  # 敌方对抗的飞机数量
        t_50_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞 否
        t_50_patrol.set_wingmanEngageDistance(300) #飞机设置  僚机可以在xx范围内侦察/交战   海里

        t_50_patrol.station_count(0)  # 为保持阵位的数量 0
        t_50_patrol.set_one_third_rule(False)  # 三分之一规则 不开启
        t_50_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析 不开启
        t_50_patrol.patrol_checkWWR(False)  # 设置任务是否对武器射程内探测目标进行分析 不开启
        t_50_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射 不开启

        t_50_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门 巡航
        t_50_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门 低速
        t_50_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门 不定
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        #打击任务
        self.ShiZong_attack = self.create_strike_mission('ShiZong_attack', MissionStrikeType.SHIP)
        self.ShiZong_attack.strike_add_target([
            contact_id for contact_id, contact_info in situation[1].items()
            if contact_info.get('Name') in {'水面#7', '水面#5'}
        ])

        # 支援任务
        self.YiEr_78_support = self.create_support_mission("YiEr_78_support", [(15.1, -88.6), (14.4, -87.4)])
        YiEr_78_support = self.get_mission_by_name('YiEr_78_support')
        unit_names = {'伊尔-96-400TZ型 #1', '伊尔-96-400TZ型 #2', '伊尔-96-400TZ型加油机',
                          '伊尔-78型 #1', '伊尔-78型 #2','伊尔-78型 #3',
                          '3MS-2 “北美野牛” Bison B 空中加油机 [Tanker] #1'}
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='YiEr_78_support', unit_list=unit_guid_list)
        YiEr_78_support.support_flightSize(FlightSize.One)  # 设置任务编队规模 单机
        YiEr_78_support.support_useFlightSize(True)  # 是否飞机数低于编队规模不允许起飞 否  ？？
        YiEr_78_support.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        YiEr_78_support.support_tanker_max_recv(2)  # 支援任务设置加油机可给飞机加油数

        YiEr_78_support.station_count(0)  # 为保持阵位的数量 0
        YiEr_78_support.set_one_third_rule(False)  # 三分之一规则 不开启
        YiEr_78_support.support_oneTimeOnly(False)  # 是否仅一次 不开启
        YiEr_78_support.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        YiEr_78_support.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环

        YiEr_78_support.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门 巡航
        YiEr_78_support.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门 低速

        #######################A100####################### ？？删除
        # self.A100_support = self.create_support_mission("A100_support", [(14.5, -89.3), (16.3, -88.8)])
        # unit_names = {'A-100 Premier 预警机 [伊尔-476] #2'}
        # unit_guid_list = [
        #     unit.get('guid', '') for unit in situation_data.values()
        #     if isinstance(unit, dict)
        #        and (unit.get('name', '') in unit_names)
        # ]
        # self.assign_units_to_mission(mission_name='A100_support', unit_list=unit_guid_list)
        # A100_support = self.get_mission_by_name('A100_support')
        # A100_support.set_one_third_rule(True)  # 三分之一规则 开启
        #######################A100#######################

        self.create_support_mission(name='A50_support', point_list=[(15.2, -90.3), (14.9, -89.8)])
        A50_support = self.get_mission_by_name('A50_support')
        unit_name_list = ['A-50U型 #2']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='A50_support', unit_list=unit_guid_list)
        A50_support.support_flightSize(FlightSize.One)  # 设置任务编队规模
        A50_support.support_useFlightSize(True)  # 是否飞机数低于编队规模不允许起飞
        A50_support.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        A50_support.support_tanker_max_recv(0)  # 支援任务设置加油机可给飞机加油数

        A50_support.station_count(0)  # 为保持阵位的数量 0
        A50_support.set_one_third_rule(False)  # 三分之一规则 不开启
        A50_support.support_oneTimeOnly(False)  # 是否仅一次 不开启
        A50_support.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开  不开启
        A50_support.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环

        A50_support.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        A50_support.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门

        self.create_support_mission(name='S100B_support', point_list=[(19.5, -83.2), (19.2, -82.9)])
        S100B_support = self.get_mission_by_name('S100B_support')
        unit_name_list = ['S 100B 型 #1']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='S100B_support', unit_list=unit_guid_list)
        S100B_support.support_flightSize(FlightSize.One)  # 设置任务编队规模
        S100B_support.support_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        S100B_support.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        S100B_support.support_tanker_max_recv(0)  # 支援任务设置加油机可给飞机加油数

        S100B_support.station_count(0)  # 为保持阵位的数量
        S100B_support.set_one_third_rule(False)  # 三分之一规则
        S100B_support.support_oneTimeOnly(False)  # 是否仅一次
        S100B_support.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        S100B_support.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环

        S100B_support.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        S100B_support.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门

        self.create_support_mission(name='E_back_row_support', point_list=[(16.048, -90.99), (15.868, -90.314)])
        E_back_row_support = self.get_mission_by_name('E_back_row_support')
        unit_names = {'图-160M Blackjack 轰炸机 #1', '图-160M Blackjack 轰炸机 #2', '图-142MZ型 #1', '图-22MR 型 #1',
                          '图-22MR 型 #2', '图-22M-3M型 #1', '图-22M-3M型 #2', '图-22M-3M型 #3', '图-22M-3M型 #4', '图-22M-3M型 #5',
                          '图-22M-3M型 #6', '苏-34“鸭嘴兽”轰炸机 #1', '苏-34“鸭嘴兽”轰炸机 #2', '苏-34“鸭嘴兽”轰炸机 #3', '苏-34“鸭嘴兽”轰炸机 #4'}
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_names)
        ]
        self.assign_units_to_mission(mission_name='E_back_row_support', unit_list=unit_guid_list[:10])#注意：这里assign_units_to_mission将单元拆分两次下发，因为平台设置下发指令长度不超过300
        self.assign_units_to_mission(mission_name='E_back_row_support', unit_list=unit_guid_list[10:])
        E_back_row_support.support_flightSize(FlightSize.One)  # 设置任务编队规模
        E_back_row_support.support_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        E_back_row_support.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        E_back_row_support.support_tanker_max_recv(0)  # 支援任务设置加油机可给飞机加油数

        E_back_row_support.station_count(0)  # 为保持阵位的数量
        E_back_row_support.set_one_third_rule(False)  # 三分之一规则
        E_back_row_support.support_oneTimeOnly(False)  # 是否仅一次
        E_back_row_support.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        E_back_row_support.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环

        E_back_row_support.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        E_back_row_support.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门

        # 设置任务的加油计划
        missions = self.missions_obj
        for mission_k, mission_v in missions.items():
            mission_v.use_tanker('Automatic')  # 自动选择加油机
            mission_v.set_mission_fuelQtyToStartLookingForTanker_airborne(30)  # 受油机低于30%油量前往加油机
            mission_v.set_mission_tankerMaxDistance_airborne(450)  # 空中受油机多远距离上寻找加油机
        # self.doctrine_weapon_control_status_air(WeaponControlStatus.Tight)  # 设置开火条件为：谨慎开火
        print("=================任务设置完毕=================")
        text = "=================任务设置完毕================="  # 智能体调度消息输出
        test = self.agent_message_text(text=text)
        print(f'纯文本显示输出返回：{test}')

        self.log.info('%s:%s initial game' % (self.Name, self.__class__.__name__))

    def step(self, time_elapse, situation):
        """
        # 每步决策函数
        :param time_elapse:  int, time elapse
        :param situation: tuple: units-list, contacts-list
        :return:
        """
        print('执行step')
        self.log.info('%s:%s step game time:%d, units:%d contact:%d' %
                      (self.Name, self.__class__.__name__, time_elapse, len(situation[0]), len(situation[1])))
