# -*- coding:utf-8 -*-
# Author: WuRuizhuo

"""
蓝方初赛AI版（改进版）.scen
添加红方任务
"""

import logging
from random import uniform

from engine.LingYi.entitys import commonfunction as cf
from engine.LingYi.entitys.global_util import *
from engine.LingYi.entitys.player import Player


class Agent(Player):
    def __init__(self, side_name, params):
        Player.__init__(self, side_name)
        self.total_list = []
        self.KeyMsg_i = 0
        self.data_v = params
        if self.log is not None:
            self.log.info('%s:%s play game' % (side_name, self.__class__.__name__))
        else:
            logging.info('%s:%s play game' % (side_name, self.__class__.__name__))

    def initial(self, situation):
        """
        初始化函数，每局推演开始前被调用. 可用于任务创建、设置，条令设置，变量初始化等
        :param situation: tuple: units, contacts
        :return:
        """
        situation_data = situation[0] if isinstance(situation[0], dict) else []
        # 巡逻任务
        self.create_patrol_mission(name='O', mission_type=MissionPatrolType.AIR,
                                   point_list=[(22.2802, -87.0803), (22.2802, -83.6274), (20.8998, -83.6274),
                                               (20.8998, -87.0803)])
        o_patrol = self.get_mission_by_name('O')
        unit_name_list = ['苏-33型 #1', '苏-33型 #2', '苏-33型 #3', '米格-29K型 #1', '米格-29K型 #2', '米格-29K型 #3', '米格-29K型 #4',
                          'EF2000 型 #1', 'EF2000 型 #2', 'EF2000 型 #3', 'EF2000 型 #4', 'EF2000 型 #5',
                          '苏-30SM“侧卫G”战斗机 #5', '苏-30SM“侧卫G”战斗机 #6', '苏-30SM“侧卫G”战斗机 #7', '苏-30SM“侧卫G”战斗机 #8',
                          '苏-35S型 #4', '苏-35S型 #5', '苏-35S型 #6']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='O', unit_list=unit_guid_list)
        o_patrol.set_wingmanEngageDistance(5)
        o_patrol.station_count(0)  # 为保持阵位的数量
        o_patrol.set_one_third_rule(False)  # 三分之一规则
        o_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析
        o_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析
        o_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射
        o_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模
        o_patrol.set_flightStoengage('all')  # 敌方对抗的飞机数量
        o_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        o_patrol.patrol_set_throttle_transit(Throttle.Full)  # 设置任务的出航油门
        o_patrol.patrol_set_throttle_station(Throttle.Full)  # 设置任务的阵位油门
        o_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='MI-23', mission_type=MissionPatrolType.AIR,
                                   point_list=[(18.4963, -93.026), (18.4963, -91.8472), (16.8807, -91.8472),
                                               (16.8807, -93.026)]
                                   )
        MI_23_patrol = self.get_mission_by_name('MI-23')
        unit_name_list = ['米格-23ML“鞭挞者”战斗机  #1', '米格-23ML“鞭挞者”战斗机  #2', '米格-23ML“鞭挞者”战斗机  #3', '米格-21bis型 #1',
                          '米格-21bis型 #2']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='MI-23', unit_list=unit_guid_list)
        MI_23_patrol.set_wingmanEngageDistance(200)
        MI_23_patrol.station_count(0)  # 为保持阵位的数量
        MI_23_patrol.set_one_third_rule(False)  # 三分之一规则
        MI_23_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析
        MI_23_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析
        MI_23_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射
        MI_23_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模
        MI_23_patrol.set_flightStoengage('all')  # 敌方对抗的飞机数量
        MI_23_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        MI_23_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门
        MI_23_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        MI_23_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='MI-29', mission_type=MissionPatrolType.AIR,
                                   point_list=[(18.6915, -95.1129),
                                               (18.6915, -94.0427),
                                               (16.589254199531823, -95.72096833091577),
                                               (16.5974, -95.1129)]
                                   )
        MI_29_patrol = self.get_mission_by_name('MI-29')
        unit_name_list = ['米格-29型 #1', '米格-29型 #2', '米格-29型 #3', '米格-29型 #4',
                          '米格-29型 #5', '米格-29型 #6']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='MI-29', unit_list=unit_guid_list)
        MI_29_patrol.set_wingmanEngageDistance(300)
        MI_29_patrol.station_count(0)  # 为保持阵位的数量
        MI_29_patrol.set_one_third_rule(False)  # 三分之一规则
        MI_29_patrol.patrol_checkOPA(True)  # 设置任务是否对巡逻区外的探测目标进行分析
        MI_29_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析
        MI_29_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射
        MI_29_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模
        MI_29_patrol.set_flightStoengage('all')  # 敌方对抗的飞机数量
        MI_29_patrol.patrol_useFlightSize(True)  # 是否飞机数低于编队规模不允许起飞
        MI_29_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门
        MI_29_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        MI_29_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='75', mission_type=MissionPatrolType.AIR,
                                   point_list=[(19.937232337704785, -92.54161252683146),
                                               (21.62572930228954, -87.95473035573875),
                                               (20.013165631040334, -87.16245195416758),
                                               (18.744865650572553, -92.3528838035476)]
                                   )
        su_75_patrol = self.get_mission_by_name('75')
        unit_name_list = ['Su-75 Checkmate 战斗机 #1', 'Su-75 Checkmate 战斗机 #2', 'Su-75 Checkmate 战斗机 #3',
                          'A-100 Premier 预警机 [伊尔-476] #1']
        # 'Su-75 Checkmate 战斗机 #4',
        # 'Su-75 Checkmate 战斗机 #5', 'Su-75 Checkmate 战斗机 #6', 'Su-75 Checkmate 战斗机 #7',
        # 'Su-75 Checkmate 战斗机 #8']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='75', unit_list=unit_guid_list)
        su_75_patrol.set_wingmanEngageDistance(300)
        su_75_patrol.station_count(0)  # 为保持阵位的数量
        su_75_patrol.set_one_third_rule(False)  # 三分之一规则
        su_75_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析
        su_75_patrol.patrol_checkWWR(True)  # 设置任务是否对武器射程内探测目标进行分析
        su_75_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射
        su_75_patrol.patrol_flight_size(FlightSize.One)  # 设置任务编队规模
        su_75_patrol.set_flightStoengage('3')  # 敌方对抗的飞机数量
        su_75_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        su_75_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门
        su_75_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        su_75_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门
        su_75_patrol.doctrine_refuel(ERefuel.No)  # 设置任务不允许加油
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        self.create_patrol_mission(name='T50', mission_type=MissionPatrolType.AIR,
                                   point_list=[(16.2171, -95.7072),
                                               (19.140032844868532, -95.3449872550033),
                                               (16.2171, -93.2271),
                                               (18.78322, -93.01407)]
                                   )
        t_50_patrol = self.get_mission_by_name('T50')
        unit_name_list = ['T-50型 #1', 'T-50型 #2', 'T-50型 #3', 'T-50型 #4', '图-214R型 #1',
                          '米格-31BM型“猎狐”战斗机#1', '米格-31BM型“猎狐”战斗机#2', '米格-35型 #2']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='T50', unit_list=unit_guid_list)
        t_50_patrol.set_wingmanEngageDistance(300)
        t_50_patrol.station_count(0)  # 为保持阵位的数量
        t_50_patrol.set_one_third_rule(False)  # 三分之一规则
        t_50_patrol.patrol_checkOPA(False)  # 设置任务是否对巡逻区外的探测目标进行分析
        t_50_patrol.patrol_checkWWR(False)  # 设置任务是否对武器射程内探测目标进行分析
        t_50_patrol.patrol_activeEMCON(False)  # 设置任务是否仅在巡逻/警戒区内打开电磁辐射
        t_50_patrol.patrol_flight_size(FlightSize.Two)  # 设置任务编队规模
        t_50_patrol.set_flightStoengage('3')  # 敌方对抗的飞机数量
        t_50_patrol.patrol_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        t_50_patrol.patrol_set_throttle_transit(Throttle.Cruise)  # 设置任务的出航油门
        t_50_patrol.patrol_set_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        t_50_patrol.patrol_set_throttle_attack(Throttle.Unspecified)  # 设置任务的攻击油门
        # o_patrol.patrol_set_transitAltitude(transit_altitude)  # float, 出航高度， 单位：米，最多6位字符，例：99999.9， 888888
        # o_patrol.patrol_set_stationAltitude(station_altitude)  # float, 阵位高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attackAltitude(attack_altitude)  # float, 攻击高度， 单位：米，最多6位字符
        # o_patrol.patrol_set_attack_distance(attack_distance)  # int, 攻击距离，单位：公里

        # 支援任务
        self.create_support_mission(name='A50', point_list=[(14.947745378364797, -89.80989129611952),
                                                            (15.21275, -90.27285)])
        A50_patrol = self.get_mission_by_name('A50')
        unit_name_list = ['A-50U型 #2']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='A50', unit_list=unit_guid_list)
        A50_patrol.station_count(0)  # 为保持阵位的数量
        A50_patrol.set_one_third_rule(False)  # 三分之一规则
        A50_patrol.support_oneTimeOnly(False)  # 是否仅一次
        A50_patrol.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        A50_patrol.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环
        A50_patrol.support_flightSize(FlightSize.One)  # 设置任务编队规模
        A50_patrol.support_useFlightSize(True)  # 是否飞机数低于编队规模不允许起飞
        A50_patrol.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        A50_patrol.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        A50_patrol.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        A50_patrol.support_tanker_max_recv(0)  # 支援任务设置加油机可给飞机加油数

        self.create_support_mission(name='S100B', point_list=[(19.201928495097697, -82.9197311941043),
                                                              (19.46144104495684, -83.1519594548037)])
        S100B_patrol = self.get_mission_by_name('S100B')
        unit_name_list = ['S 100B 型 #1']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='S100B', unit_list=unit_guid_list)
        S100B_patrol.station_count(0)  # 为保持阵位的数量
        S100B_patrol.set_one_third_rule(False)  # 三分之一规则
        S100B_patrol.support_oneTimeOnly(False)  # 是否仅一次
        S100B_patrol.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        S100B_patrol.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环
        S100B_patrol.support_flightSize(FlightSize.One)  # 设置任务编队规模
        S100B_patrol.support_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        S100B_patrol.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        S100B_patrol.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        S100B_patrol.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        S100B_patrol.support_tanker_max_recv(0)  # 支援任务设置加油机可给飞机加油数

        self.create_support_mission(name='E后排', point_list=[(15.084138884782545, -88.75241823260588),
                                                            (14.359957448582817, -87.39927881743522)])
        E_patrol = self.get_mission_by_name('E后排')
        unit_name_list = ['图-160M Blackjack 轰炸机 #1', '图-160M Blackjack 轰炸机 #2', '图-142MZ型 #1', '图-22MR 型 #1',
                          '图-22MR 型 #2', '图-22M-3M型 #1', '图-22M-3M型 #2', '图-22M-3M型 #3', '图-22M-3M型 #4', '图-22M-3M型 #5',
                          '图-22M-3M型 #6', '苏-34“鸭嘴兽”轰炸机 #1', '苏-34“鸭嘴兽”轰炸机 #2', '苏-34“鸭嘴兽”轰炸机 #3', '苏-34“鸭嘴兽”轰炸机 #4']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='E后排', unit_list=unit_guid_list)
        E_patrol.station_count(0)  # 为保持阵位的数量
        E_patrol.set_one_third_rule(False)  # 三分之一规则
        E_patrol.support_oneTimeOnly(False)  # 是否仅一次
        E_patrol.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        E_patrol.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环
        E_patrol.support_flightSize(FlightSize.One)  # 设置任务编队规模
        E_patrol.support_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        E_patrol.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        E_patrol.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        E_patrol.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        E_patrol.support_tanker_max_recv(0)  # 支援任务设置加油机可给飞机加油数
        # E_patrol.patrol_set_stationAltitude(8000)  # float, 阵位高度， 单位：米，最多6位字符 # 根据苏-34“鸭嘴兽”轰炸机 #2轰炸机的空舰导弹发射高度设置
        # E_patrol.patrol_set_attackAltitude(8000)  # float, 攻击高度， 单位：米，最多6位字符

        self.create_support_mission(name='Y78', point_list=[(14.510794676591098, -89.2680135036651),
                                                            (14.348399495700436, -88.82893176704411)])
        Y78_patrol = self.get_mission_by_name('Y78')
        unit_name_list = ['伊尔-96-400TZ型 #1', '伊尔-96-400TZ型 #2', '伊尔-78型 #1', '伊尔-78型 #2',
                          '伊尔-78型 #3', '3MS-2 “北美野牛” Bison B 空中加油机 [Tanker] #1']
        unit_guid_list = [
            unit.get('guid', '') for unit in situation_data.values()
            if isinstance(unit, dict)
               and (unit.get('name', '') in unit_name_list)
        ]
        self.assign_units_to_mission(mission_name='Y78', unit_list=unit_guid_list)
        Y78_patrol.station_count(0)  # 为保持阵位的数量
        Y78_patrol.set_one_third_rule(False)  # 三分之一规则
        Y78_patrol.support_oneTimeOnly(False)  # 是否仅一次
        Y78_patrol.support_activeEMCON(False)  # 仅在阵位上打开电磁辐射 True:打开, False:不打开
        Y78_patrol.support_loopType(False)  # 导航类型 True-仅一次；False-连续循环
        Y78_patrol.support_flightSize(FlightSize.One)  # 设置任务编队规模
        Y78_patrol.support_useFlightSize(False)  # 是否飞机数低于编队规模不允许起飞
        Y78_patrol.support_throttle_transit(Throttle.Cruise)  # 设置任务的飞机出航油门
        Y78_patrol.support_throttle_station(Throttle.Loiter)  # 设置任务的阵位油门
        Y78_patrol.support_tanker_one_time(False)  # 支援任务设置一个加油周期后，加油队列为空时，加油机返回起降机场
        Y78_patrol.support_tanker_max_recv(2)  # 支援任务设置加油机可给飞机加油数

        self.log.info('%s:%s initial game' % (self.Name, self.__class__.__name__))

    def step(self, time_elapse, situation):
        """
        # 每步决策函数
        :param time_elapse:  int, time elapse
        :param situation: tuple: units-list, contacts-list
        :return:
        """
        self.log.info('%s:%s step game time:%d, units:%d contact:%d' %
                      (self.Name, self.__class__.__name__, time_elapse, len(situation[0]), len(situation[1])))

    def deduction_end(self):
        # agent结束后自动被调用函数， 可保存模型，比如记录本局策略后的得分等
        self.total_list.append(self.TotalScore)
        logging.info('%s:%s play game result:%d' % (self.Name, self.__class__.__name__, self.TotalScore))

    def is_done(self):
        # agent主动结束本局推演，比如一定胜利或失败后
        # 只能训练时调用此函数，比赛对战时此函数不可用
        if self.TotalScore >= 1500 or self.TotalScore <= -1500:
            return True
        return False
