# -*- coding:utf-8 -*-
# Author: MouQingPing

"""
红方
"""

from engine.LingYi.entitys.player import Player
from agent.rule_agent.air_combat.calculate_threat_level_of_the_target import ThreatEvaluator
from agent.rule_agent.air_combat.calculate_weapon_attack_air_rate import calculate_possibility
import numpy as np
from engine.LingYi.entitys.global_util import *


# from ...entitys.agent_base import *

class Agent(Player):
    def __init__(self, side_name, params):
        super(Agent, self).__init__(side_name)
        self.IsDone = False
        self.target_id_save = []
        self.target_id_save_for_MI29 = []
        self.params = params
        # 进行服务器赋值

    def initial(self, situation):
        """
        初始化函数，每局推演开始前被调用. 可用于任务创建、设置，条令设置，变量初始化等
        :param situation: tuple: units, contacts
        :return:
        """

        ##下面是智能体1需要的任务设置、条令设置，在baseline_doctrine_add_mission中也有相关设置
        ##如果没有预先运行baseline_doctrine_add_mission下的任务和条令设置，需要使用下面代码进行任务条令设置
        # 燃油状态，预先规划
        # self.doctrine_fuel_state_planned(FuelState.Bingo)
        # # 设置燃油状态返航
        # self.doctrine_fuel_state_rtb(FuelStateRTB.No)
        # # 设置武器状态，预先规划
        # self.doctrine_weapon_state_planned(WeaponStatePlanned.WinchesterUseAirGuns)
        # # 设置武器状态返航
        # self.doctrine_weapon_state_rtb(WeaponStateRTB.No)
        #
        # # 创建空战巡逻任务、支援任务
        # self.MI_23_patrol = self.create_patrol_mission("MI_23_patrol", MissionPatrolType.AIR,
        #                                                [(18.288, -91.908), (18.257, -91.434), (17.638, -91.6545),
        #                                                 (17.686, -91.956)])   # 巡逻任务
        # self.MI_29_patrol = self.create_patrol_mission("MI_29_patrol", MissionPatrolType.AIR,
        #                                                [(18.602, -93.131), (18.588, -92.069), (16.625, -92.202),
        #                                                 (16.609, -93.197)])
        # self.T50_patrol = self.create_patrol_mission("T50_patrol", MissionPatrolType.AIR,
        #                                              [(19.1, -95.4), (18.9, -93.132), (16.2, -93.2), (16.2, -95.7)])
        # self.YiEr_78 = self.create_support_mission("YiEr_78", [(16.048, -90.99), (15.472, -90.064)])  # 支援任务
        #
        # # 设置巡逻任务、支援任务不执行三分之一规则
        # self.MI_23_patrol.set_one_third_rule(False)
        # self.MI_29_patrol.set_one_third_rule(False)
        # self.T50_patrol.set_one_third_rule(False)
        # self.YiEr_78.set_one_third_rule(False)
        #
        #
        # # 设置巡逻任务不执行：对巡逻区外的探测目标进行分析
        # self.MI_23_patrol.patrol_checkOPA(False)
        # self.MI_29_patrol.patrol_checkOPA(False)
        # self.T50_patrol.patrol_checkOPA(False)
        #
        #
        # #设置任务单元
        # MI_23 = []  # 所有米格23飞机
        # MI_29 = []  # 所有米格29飞机
        # MI_T50 = []  # 所有T50飞机
        # MI_YiEr = []  # 所有YiEr加油机
        # for guid,unit in situation[0].items():
        #     # 遍历本分所有单元
        #     if unit['category'] == 'Aircraft':
        #         if unit['dbid'] == 1342 or unit['dbid'] == 2734:
        #             # 是米格23飞机
        #             MI_23.append(unit["guid"])
        #             uint_id = unit["guid"]
        #             self.MI_23_patrol.assign_unit(uint_id)
        #         elif unit['dbid'] == 2346:
        #             # 是米格29飞机
        #             MI_29.append(unit["guid"])
        #             uint_id = unit["guid"]
        #             self.MI_29_patrol.assign_unit(uint_id)
        #         elif unit['dbid'] == 2232:
        #             # 是T50
        #             MI_T50.append(unit["guid"])
        #             uint_id = unit["guid"]
        #             self.T50_patrol.assign_unit(uint_id)
        #         elif unit['dbid'] == 2686:
        #             # 是YiEr加油机
        #             MI_YiEr.append(unit["guid"])
        #             uint_id = unit["guid"]
        #             self.YiEr_78.assign_unit(uint_id)
        #
        # #设置任务的加油计划
        # missions = self.missions_obj
        # for mission_k,mission_v in missions.items():
        #     mission_v.use_tanker('Automatic')  #自动选择加油机
        #     mission_v.set_mission_fuelQtyToStartLookingForTanker_airborne(30) #受油机低于30%油量前往加油机
        #     mission_v.set_mission_tankerMaxDistance_airborne(450)    #空中受油机多远距离上寻找加油机
        # self.doctrine_weapon_control_status_air(WeaponControlStatus.Tight)   #设置开火条件为：谨慎开火
        print("地空导弹分队#1打击H国第一波空中攻击")
        test = self.agent_message_text(text='地空导弹分队#1打击H国第一波空中攻击')  # 前端调度时的打印输出，调试时可注释
        print(f'纯文本显示输出返回：{test}')  # 前端调度时的打印输出，调试时可注释

    def step(self, time_elapse, situation):
        """
         agents_info, action_dict  为强化学习使用参数，规则智能体不需要，可不填写
        # 每步决策函数
        :param time_elapse:  int, time elapse
        :param situation: tuple: units-list, contacts-list
        :return:
        """
        """
        1   空战小场景：阻敌作战
            我方单元：地空导弹分队(SA-5c型“甘蒙”防空导弹 [S-200M型“织女星M”导弹], 2x 营)#1、6架米格-29型多用途飞机
            敌方单元：10架多用途战斗机
            场景描述：敌方H国派遣10架多用途战斗机，巡逻我方重要单元(C国机场)，且攻击我方正在巡逻的6架米格-29飞机
        2   战术设计：
            （1）地空导弹营根据威胁度、命中率结果提前规划打击目标，击落部分来袭敌机
            （2）敌机接近我方C国机场后，米格-29飞机根据威胁度、命中率实施近战打击
            （3）飞机无可打击武器后返回机场，还有打击武器则继续巡逻任务
            （4）实时监控飞机的油量状态，在油量较低时分配加油机前往支援
                a.加油机分配原则：油量比<1/3分配加油；最近分配原则
                b.飞机返航原则：加油机太远则飞机返航；加油机没太多油飞机也返航
        """

        #前端选择单元
        select_units_guid = self.client_info['unit'].keys()

        targets = []
        targets_id = []
        targets_all = []
        if isinstance(situation[1], dict):
            for t_id,contact in situation[1].items():
                # 遍历所有获取的情报
                if not isinstance(contact, str):
                    if 'Type' in contact:     #屏蔽Type缺失的错误
                        try:
                            if contact['Type'] == 0 and contact['Lon'] < -92 and contact['Lon'] > -96:
                                #找到对方在西经92~96之间的飞机 计算飞机的威胁度
                                if contact.get('CurrentSpeed'):   #临时使用，speed字段不存在的时候设置为0
                                    target = {'lon' : contact['Lon'],'lat': contact['Lat'],'alt' : contact['CurrentAltitude'],
                                              'speed' : contact['CurrentSpeed'],'head' : contact['CurrentHeading'],'aircraft_type' : contact['ActCategory']}
                                else:
                                    target = {'lon': contact['Lon'], 'lat': contact['Lat'], 'alt': contact['CurrentAltitude'],
                                              'speed': 0.0, 'head': contact['CurrentHeading'],
                                              'aircraft_type': contact['ActCategory']}
                                targets_id.append(t_id)
                                targets_all.append(contact)
                                targets.append(target)
                        except:
                            print("缺失Type字段!!!!")   #调试打印输出
                            test = self.agent_message_text(text='缺失Type字段！！！')  #前端调度时的打印输出，调试时可注释
                            print(f'纯文本显示输出返回：{test}') #前端调度时的打印输出，调试时可注释
                    else:
                        print("contact信息不全！！！")   #调试打印输出
                        test = self.agent_message_text(text='contact信息不全！！！') #前端调度时的打印输出，调试时可注释
                        print(f'纯文本显示输出返回：{test}') #前端调度时的打印输出，调试时可注释


        ###设置地空导弹营的战术###
        print("地空导弹营: ")
        self_units = []

        # 设置方式1：需要前端选择单元 start #
        select_dikong = []

        units_list = []
        for guid,unit in situation[0].items():
            units_list.append(unit)

        for unit_1 in units_list:
            if unit_1['guid'] in select_units_guid and unit_1['name'] == '地空导弹分队(SA-5c型“甘蒙”防空导弹 [S-200M型“织女星M”导弹], 2x 营)#1':
                select_dikong.append(unit_1['guid'])
        units_select_dikong = select_dikong
        # 设置方式1：需要前端选择单元 end #

        # 设置方式2：不需要前前端选择单元 start #
        # units_select_dikong = ['zjj7bf-0hn9c004pi2o1'] #地空导弹营#1
        # 设置方式2：不需要前前端选择单元 end #

        for unit in units_list:
            if unit['guid'] in units_select_dikong:
                unit_info = {'lon': unit['lon'], 'lat': unit['lat'], 'alt': unit['alt'],
                        'speed': unit['speed'], 'head': unit['head']}
                self_units.append(unit_info)

        evaluator = ThreatEvaluator()  #计算威胁矩阵
        threat_mat_di = evaluator.threat_matrix(targets,self_units)  #显示威胁矩阵

        #计算武器打击概率
        attack_rate_mat_di = np.zeros((len(targets_all), len(self_units)))
        for i, target_cal in enumerate(targets_all):
            for j, unit_cal in enumerate(self_units):
                contact_proficiency_level = 2
                unit_target_distance = evaluator.get_horizontal_distance(unit_cal['lon'], unit_cal['lat'],
                                                                       target_cal['Lon'], target_cal['Lat'])
                try:  # 武器不存了，打击率为0
                    attack_rate = calculate_possibility(1827, target_cal, contact_proficiency_level,
                                                        unit_target_distance)
                except:
                    attack_rate = 0.0
                attack_rate_mat_di[i][j] = attack_rate
        print("weapon1827_attack_target_rate: ", attack_rate_mat_di)

        # result_mat_di = threat_mat_di
        #计算总概率  分配打击武器
        result_mat_di = threat_mat_di + attack_rate_mat_di
        targets_units_relationship = evaluator.get_target_unit_relationship(result_mat_di,0.5,True)
        for rela_key,rela_value in targets_units_relationship.items():
            if len(rela_value)>0 :
                unit_id_attack = units_select_dikong[rela_key]      #我方打击单元id 地空导弹营#1
                unitObj = self.get_unit(unit_id_attack)      #地空导弹营对象
                for i in range(len(rela_value)):
                    target_id_attack = targets_id[i]         #被打击的目标id
                    if unitObj is not None:
                        weapon_info = unitObj.get_weapon_info()
                    if target_id_attack not in self.target_id_save:
                        self.target_id_save.append(target_id_attack)
                        if 1827 in weapon_info and weapon_info[1827] > 1:     #注意：如果打2枚弹，则判断条件为大于1
                            s = unitObj.attack_weapon_allocate_to_target(target_id_attack,1827,2)
                            test = self.agent_message_text(text='地空导弹营打击')
                            print(f'纯文本显示输出返回：{test}')
        print("############地空导弹营 ############\n")

        ###设置MI29的战术###
        print("\nMI29: ")
        self_units_MI29 = []
        self_units_MI29_ID = []
        units_MI29_all = []

        # 设置方式1：需要前端选择单元 start #
        select_MI29 = []
        for unit_1 in units_list:
            if unit_1['guid'] in select_units_guid and '米格' in unit_1['name']:
                select_MI29.append(unit_1['guid'])
        units_MI29_select = select_MI29
        # 设置方式1：需要前端选择单元 end #

        # 设置方式2：不需要前前端选择单元 start #
        # units_MI29_select = ['zjj7bf-0hn937r864mak','zjj7bf-0hn937r864mbs','zjj7bf-0hn937r864md4',\
        #                      'zjj7bf-0hn937r864mec','zjj7bf-0hn937r864mfk','zjj7bf-0hn937r864mgs']  # 米格29
        # 设置方式2：不需要前前端选择单元 end #
        for unit in units_list:
            if unit['guid'] in units_MI29_select:
                unit_info = {'lon': unit['lon'], 'lat': unit['lat'], 'alt': unit['alt'],
                             'speed': unit['speed'], 'head': unit['head']}
                units_MI29_all.append(unit)
                self_units_MI29.append(unit_info)
                self_units_MI29_ID.append(unit['guid'])
        threat_mat_MI29 = evaluator.threat_matrix(targets,self_units_MI29)

        attack_rate_mat_MI29_1896 = np.zeros((len(targets_all), len(self_units_MI29)))
        attack_rate_mat_MI29_1901 = np.zeros((len(targets_all), len(self_units_MI29)))
        for i, target_cal in enumerate(targets_all):
            for j, unit_cal in enumerate(self_units_MI29):
                contact_proficiency_level = 2
                unit_target_distance = evaluator.get_horizontal_distance(unit_cal['lon'], unit_cal['lat'],
                                                                       target_cal['Lon'], target_cal['Lat'])
                try:  # 武器不存了，打击率为0
                    attack_rate_1896 = calculate_possibility(1896, target_cal, contact_proficiency_level,
                                                             unit_target_distance)
                    attack_rate_1901 = calculate_possibility(1901, target_cal, contact_proficiency_level,
                                                             unit_target_distance)
                except:
                    attack_rate_1896 = 0.0
                    attack_rate_1901 = 0.0
                attack_rate_mat_MI29_1896[i][j] = attack_rate_1896
                attack_rate_mat_MI29_1901[i][j] = attack_rate_1901
        print("weapon1896_attack_target_rate: ", attack_rate_mat_MI29_1896)
        print("weapon1901_attack_target_rate: ", attack_rate_mat_MI29_1896)

        # result_mat_MI29 = threat_mat_MI29
        result_mat_MI29_1896 = threat_mat_MI29 + attack_rate_mat_MI29_1896
        result_mat_MI29_1901 = threat_mat_MI29 + attack_rate_mat_MI29_1901
        targets_units_relationship_MI29 = evaluator.get_target_unit_relationship(result_mat_MI29_1896,0.6,True)
        for rela_key,rela_value in targets_units_relationship_MI29.items():
            if len(rela_value)>0 :
                unit_id_attack = self_units_MI29_ID[rela_key]      #我方打击单元id MI29
                unitObj = self.get_unit(unit_id_attack)         #MI29对象
                for i in range(len(rela_value)):
                    target_id_attack = targets_id[i]         #被打击的目标id
                    if unitObj is not None:
                        weapon_info = unitObj.get_weapon_info()
                    if target_id_attack not in self.target_id_save_for_MI29:
                        self.target_id_save_for_MI29.append(target_id_attack)
                        if 1901 in weapon_info and weapon_info[1901] > 0:
                            try:
                                s = unitObj.attack_weapon_allocate_to_target(target_id_attack, 1901, 1)
                                test = self.agent_message_text(text='MI29打击')
                                print(f'纯文本显示输出返回：{test}')
                            except:
                                print("单元对象不存在，请选择正确的单元！")
                        if 1896 in weapon_info and weapon_info[1896] > 1:
                            try:
                                s = unitObj.attack_weapon_allocate_to_target(target_id_attack, 1896, 2)
                                test = self.agent_message_text(text='MI29打击')
                                print(f'纯文本显示输出返回：{test}')
                            except:
                                print("单元对象不存在，请选择正确的单元！")
        print("##############MI29: ##############")


