# _*_ coding: utf-8 _*_
# @Author : wm
# @Date : 2024-11-4
# @Version :V0.02
# @description :  地导拦截情况可视化文件

import matplotlib
matplotlib.use("TKAgg")
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from data.generate_data import *
from matplotlib.colorbar import ColorbarBase
from scipy.interpolate import UnivariateSpline
from matplotlib.patches import Circle

# 设置字体为SimHei显示中文
plt.rcParams['font.sans-serif'] = ['SimHei']
# 设置正常显示符号
plt.rcParams['axes.unicode_minus'] = False

# 区域范围
latitude_range = [35.9, 43.2]  # 纬度范围
longitude_range = [115.3, 121.2]  # 经度范围


def curve_fitting(start_point, middle_point, end_point):
    """
    根据给定的起点、中点和终点，进行目标运动轨迹拟合
    :param start_point:起点
    :param middle_point:中间
    :param end_point:终点
    :return 拟合曲线
    """
    # 定义起点、终点和中间点
    point_lst = [start_point, middle_point, end_point]
    point_lst.sort(key=lambda x: x[0])
    x_data = [point_lst[0][0], point_lst[1][0], point_lst[2][0]]
    y_data = [point_lst[0][1], point_lst[1][1], point_lst[2][1]]

    # 使用UnivariateSpline拟合曲线，参数k控制函数的次数
    spline = UnivariateSpline(x_data, y_data, k=1, s=0)

    # 生成均匀分布的x值，用于绘制曲线
    x = np.linspace(min(x_data), max(x_data), 100)
    y = spline(x)

    return x, y

def visualization(situation_info, simulation_result):
    """
    根据态势和拦截结果，处理可视化数据
    :param situation_info:当前态势
    :param simulation_result:拦截结果
    """
    # 获取地导营和目标数据
    target_info = situation_info["target_info"]
    unit_info = situation_info["unit_info"]
    # 按照拦截时间进行排序拦截情况
    explosions = []
    explosions_id = []
    # 地导营拦截成功/拦截失败/地导营无可用时间窗口的情况
    for i, ground_missile_result in simulation_result.items():
        for missile in ground_missile_result:
            j = missile['target_id']
            if missile is not None:
                explosions.append([j, missile['explosion_time'], missile['explosion_loc'], missile['state'], target_info[j]['velocity'], target_info[j]['theta_degrees'], target_info[j]['location'], target_info[j]['goal_location'], target_info[j]['threat'], i, missile['used_ammunition_amount']])
                explosions_id.append(j)
            else:
                hit_time = get_horizontal_distance(target_info[j]['location'], target_info[j]['goal_location']) / \
                           target_info[j]['velocity'] * 3600  # 目标打击到预定终点的时间
                explosions.append([j, hit_time, target_info[j]['goal_location'], 'disappeared', target_info[j]['velocity'],
                                   target_info[j]['theta_degrees'], target_info[j]['location'], target_info[j]['goal_location'], target_info[j]['threat'], None])
                explosions_id.append(j)
    # 目标在分配的地导营的拦截范围外的情况
    for m, target in target_info.items():
        if m not in explosions_id:
            hit_time = get_horizontal_distance(target_info[m]['location'], target_info[m]['goal_location']) / \
                       target_info[m]['velocity'] * 3600  # 目标打击到预定终点的时间
            explosions.append([m, hit_time, target_info[m]['goal_location'], 'disappeared', target_info[m]['velocity'],
                               target_info[m]['theta_degrees'], target_info[m]['location'], target_info[m]['goal_location'], target_info[m]['threat'], None, None])
    explosions.sort(key=lambda x: x[1])
    return explosions



