# -*- coding:utf-8 -*-
# Author: MouQingPing

"""
红方
"""

from agent.rule_agent.CM_Trajectory_planning.calculate_distance_and_extend_path import *
from agent.rule_agent.CM_Trajectory_planning.call_Dijkstra import *
from agent.rule_agent.CM_Trajectory_planning.judge import *
from engine.LingYi.entitys.player import Player

class Agent(Player):
    def __init__(self, side_name, params):
        super(Agent, self).__init__(side_name)
        # self.client_select_info = params
        self.flag_withdraw_mission = False  # 飞机任务取消flag
        self.flag_set_ref_point = False  # 飞机设置航路点flag
        self.flag_arrival_points = False  # 飞机到达航路点flag
        self.count_step = 0  # 记录运行步数
        self.flag_weapon_allocate_to_target = False  # 飞机发射武器flag
        self.flag_weapon_allocate_to_target_success = False  # 飞机发射武器成功flag
        self.next_step_set_plotted_course = 0  # 飞机在下一步再设置路径
        self.flag_weapon_set_plotted_course_success = False  # 武器设置路径成功flag
        self.flag_back_to_mission = False  # 飞机回到原任务flag
        self.flag_launch_condition = False  # 是否满足发射条件flag
        self.flag_updata_course = False  # 设置路径更新的flag

        self.record_mission_id = {}

        self.agent = None
        self.start_pose = None
        self.end_pose = None

        # 路径规划参数
        self.ratio = 0.1  # 地图精度
        self.step_length = 5  # 路径更新步长

        # 路径规划结果
        self.path_dic = {}


    def initial(self, situation):
        test = self.agent_message_text(text='CM_Trajectory_planning智能体运行')  # 智能体调度消息输出
        print(f'纯文本显示输出返回：{test}')

        print("=================任务设置成功后启动=================")

    def step(self, time_elapse, situation):
        """
        1   作战场景：巡航导弹打击敌方高价值地面设施
            我方单元：图-22M-3M型 #1、图-22M-3M型 #2、图-22M-3M型 #3
            敌方单元：H国机场
            场景描述：H国机场作为敌方高价值得分单元，摧毁该目标可使敌方区域空中作战效能大幅下降
        2   战术设计：
            （1）判断飞机是否都有任务，有任务飞机取消当前任务
            （2）设置飞机到达同一地点（参考点），判断飞机是否到达同一参考点
            （3）达到同一参考点后，飞机发射武器，判断武器是否全都正确发射
            （4）为武器进行轨迹规划，判断武器是否都正确规划航路点
            （5）武器都正常发射后，之前有任务的飞机返回任务；无任务飞机原地飞行，等待新的任务
        3   参数说明：          
            （1）飞机从同一地点发射武器，实施饱和打击，需确认地图中该地点的坐标位置，也即ref_point
            （2）飞机发射武器确认，即武器weapon_id(武器的dbid)
            （3）飞机发射武器数量确认，即weapon_num(注意查看携带的最大武器数weapon_max，weapon_num<=weapon_num）
        """

        # 选手可自定义参数设置

        weapon_id = 3122  # 3122是巡航导弹“厨房”的weapon_id
        weapon_num = 2  # 发射武器数量

        units_list = []
        for guid,unit in situation[0].items():
            units_list.append(unit)

        units = units_list  # 态势中的我方信息
        contacts = situation[1]  # 态势中的敌方信息

        ######### 选择单元、参考点、敌方情报  #########
        # point_select_guid_list = list(self.client_info['point'].keys())    #方式1：前端选择已存在参考点
        ref_point = [(16.183, -91.262)]  # 飞机共同到达参考点,方式2：代码中设定该点

        units_select_guid_list = list(self.client_info['unit'].keys())  #方式1：前端选择的单元

        # units_select_guid_list = ['zjj7bf-0hnb43oust768', 'zjj7bf-0hnb43oust77n'
        #                           ]  # 方式2:代码中设定单元

        # contact_select_list = list(self.client_info['contact'].keys()) ##方式1：前端选择的敌方情报
        contact_select_list = ['zjj7bf-0hnbcddo2ajmk']  # 方式2:代码中设定选择contact的guid  目前只支持单个目标

        units_select_info = []
        for unit_select_guid in units_select_guid_list:
            for unit in units:
                if "guid" in unit and unit_select_guid == unit['guid']:
                    units_select_info.append(unit)

        contact_select_info = {}
        for contact_select_guid in contact_select_list:
            for contact_guid,contact in contacts.items():
                if contact_select_guid == contact_guid:
                    contact_select_info[contact_guid] = contact
        ######### 选择单元、参考点、敌方情报 end #########


        ### 判断飞机是否有任务，有任务取消任务 ###
        if not self.flag_withdraw_mission:
            for unit in units_select_info:
                if unit['mission']:
                    self.record_mission_id[unit['guid']] = unit['mission']
                    unitObj = self.get_unit(unit['guid'])  # 获取单元对象
                    unitObj.withdraw_from_mission()
                    self.flag_withdraw_mission = True
                    print("==========Set Tu22M To withdraw_mission==========")
                    test = self.agent_message_text(text='Tu22M-3M取消任务') #智能体调度消息输出
                    print(f'纯文本显示输出返回：{test}')

        ### 给飞机设置航线到达参考点  ###
        if not self.flag_set_ref_point and self.flag_withdraw_mission and self.count_step > 1:
            count_set_ref_point = 0
            for unit in units_select_info:
                unitObj = self.get_unit(unit['guid'])
                unitObj.plotted_course(ref_point)
                count_set_ref_point += 1
                print(f"==========Set Tu22M To ref_point=========={unit.get('guid')} : ", count_set_ref_point) #智能体调度消息输出
                test = self.agent_message_text(text='Tu22M-3M前往参考点')
                print(f'纯文本显示输出返回：{test}')
            if count_set_ref_point == len(units_select_info):
                self.flag_set_ref_point = True

        ### 判断飞机是否到达参考点 ###
        if self.flag_set_ref_point and not self.flag_arrival_points:
            all_arrived = check_all_units_arrived(
                units_select_info,
                ref_point=ref_point,  # 确保ref_point格式为[(lat,lon)]
                tolerance=0.08)
            if all_arrived:
                self.flag_arrival_points = True
                print("全部单位已到达目标点")
                test = self.agent_message_text(text='全部单位已到达目标点') #智能体调度消息输出
                print(f'纯文本显示输出返回：{test}')
            else:
                print("仍有单位未到达目标点")
                # test = self.agent_message_text(text='仍有单位未到达目标点') #智能体调度消息输出
                # print(f'纯文本显示输出返回：{test}')

        ### 到达参考点后，发射巡航导弹 ###

        if self.flag_arrival_points and not self.flag_weapon_allocate_to_target:
            target_id_attack = contact_select_list[0] # 目前只支持单个目标  敌方H国机场
            count_weapon_allocate_to_target = 0
            for guid in units_select_guid_list:
                unitObj = self.get_unit(guid)
                if unitObj is not None:
                    weapon_info = unitObj.get_weapon_info()
                    if weapon_id in weapon_info and weapon_info[weapon_id] > weapon_num-1:
                        s = unitObj.attack_weapon_allocate_to_target(target_id_attack, weapon_id,
                                                                     weapon_num)  # 打击指令下发
                        count_weapon_allocate_to_target += 1  #开火计数
                        print("==========Set Tu22M Weapon_allocate==========%d: " % count_weapon_allocate_to_target)

            if count_weapon_allocate_to_target == len(units_select_guid_list):
                self.flag_weapon_allocate_to_target = True

        weapon_num_sum = weapon_num * len(units_select_guid_list)
        if self.flag_weapon_allocate_to_target and not self.flag_weapon_allocate_to_target_success:
            count_weapon_id = 0
            try:
                for unit in units:
                    if unit['category'] == 'Weapon' and unit['dbid'] == weapon_id:
                        count_weapon_id += 1
            except:
                print("ddd")
            if count_weapon_id == weapon_num_sum:
                self.flag_weapon_allocate_to_target_success = True
                self.next_step_set_plotted_course = 1
                print(f"==========全部武器发射，发射武器数是：{weapon_num_sum}==========")


        ### 如果巡航导弹发出，则设置导弹航线 ###
        if self.flag_weapon_allocate_to_target_success and not self.flag_weapon_set_plotted_course_success:
            self.next_step_set_plotted_course += 1
            if self.next_step_set_plotted_course > 2:
                flag_weapon_unit_exists = False
                count_weapon_set_plotted_course = 0
                path_dic = {}
                path_length_dic = {}
                for unit in units:
                    if unit['category'] == 'Weapon' and unit['dbid'] == weapon_id:
                        flag_weapon_unit_exists = True  # 武器单元存在
                        # D*算法设置巡航导弹航线
                        course_list = call_d_start(unit, contact_select_list, contacts, self.ratio)
                        path_length = compute_path_length_geo(course_list)
                        path_dic[unit['guid']] = course_list
                        path_length_dic[unit['guid']] = path_length

                # 计算航线的延长线
                if flag_weapon_unit_exists:
                    path_extend = extend_all_paths_with_curved_detour(path_dic, path_length_dic)

                    for guid, new_path in path_extend.items():
                        ChuFang_unitObj = self.get_unit(guid)
                        ChuFang_unitObj.plotted_course(new_path)
                        count_weapon_set_plotted_course += 1
                        print(f"==========Set ChuFang plotted_course：{unit['guid']}==========")

                if count_weapon_set_plotted_course == weapon_num_sum:
                    self.flag_weapon_set_plotted_course_success = True
                    self.flag_updata_course = True
                print(f"==========Set ChuFang plotted_course END==========")
                test = self.agent_message_text(text="巡航导弹第一次路径规划完成") #智能体调度消息输出
                print(f'纯文本显示输出返回：{test}')

        ### 单元执行完发射，则返回原任务 ###
        if self.flag_weapon_allocate_to_target_success and not self.flag_back_to_mission:
            count_back_to_mission = 0
            for guid, mission_id in self.record_mission_id.items():
                unitObj = self.get_unit(guid)
                unitObj.assign_to_mission(mission_id)
                count_back_to_mission += 1
            if len(self.record_mission_id) == count_back_to_mission:
                self.flag_back_to_mission = True
                print(f"==========Set Tu22M Back to Mission==========")
                test = self.agent_message_text(text="Tu22M-3M返回任务") #智能体调度消息输出
                print(f'纯文本显示输出返回：{test}')

        ### 武器更新航路点 ###
        if self.flag_updata_course and self.count_step % self.step_length == 0:  # elf.step_length=5时，每5步更新一次路径
            count_weapon_set_plotted_course = 0
            flag_weapon_unit_exists = False
            path_dic = {}
            path_length_dic = {}
            for unit in units:
                if unit['category'] == 'Weapon' and unit['dbid'] == weapon_id:
                    flag_weapon_unit_exists = True  # 武器单元存在
                    # D*算法设置巡航导弹航线
                    course_list = call_d_start(unit, contact_select_list, contacts, self.ratio)
                    path_length = compute_path_length_geo(course_list)
                    path_dic[unit['guid']] = course_list
                    path_length_dic[unit['guid']] = path_length

            # 计算航线的延长线
            if flag_weapon_unit_exists:
                path_extend = extend_all_paths_with_curved_detour(path_dic, path_length_dic)
                for guid, new_path in path_extend.items():
                    ChuFang_unitObj = self.get_unit(guid)
                    ChuFang_unitObj.plotted_course(new_path)
                    count_weapon_set_plotted_course += 1
                    print(f"==========Set ChuFang plotted_course：{unit['guid']}==========")
                    test = self.agent_message_text(text = "设置巡航导弹路径") #智能体调度消息输出
                    print(f'纯文本显示输出返回：{test}')

        self.count_step += 1
        print("==========Set ChuFang END==========")
