def check_all_units_arrived(units, ref_point, tolerance=0.05):
    """
    判断所有单元是否到达参考点
    参数：
        units: 单位列表，每个单位需包含latitude和longitude字段
        ref_point: 参考点，格式为[(lat, lon)]的列表
        tolerance: 坐标容差（单位：度）
    返回：
        bool 是否全部到达
    """
    if not units or not ref_point:
        return False

    ref_lat, ref_lon = ref_point[0]  # 解包参考点坐标
    required_count = len(units)
    arrived_count = 0

    for unit in units:
        u_lat = unit['lat']
        u_lon = unit['lon']
        if (abs(u_lat - ref_lat) <= tolerance and
                abs(u_lon - ref_lon) <= tolerance):
            arrived_count += 1

    return arrived_count == required_count
