import numpy as np
from agent.rule_agent.CM_Trajectory_planning.Dijkstra import Dijkstra


def call_d_start(unit, contact_select_list, contacts, ratio):
    """
         调用d_start路径规划算法
         参数：
                unit：需要进行路径规划的我方单元字，是路径规划的起点，注意字典中需要包含'latitude'、'longitude'字段
                contact_select_info：选择的敌方单元字典，是路径规划的终点，注意字典中需要包含'Lat'、'Lon'、'guid'字段
                contacts：所有我方探测到的敌方信息，是路径规划的可能障碍点，需要避开
                ratio：建立栅格地图精度
                       (1)若为0.1表示每个栅格跨越0.1度，大约精度在8.7~11.1km
                       (2)若为0.01表示每个栅格跨越0.01度，大约精度在0.87~1.11km，具体取决于单元的方向和经纬度
                       (3)具体设置，可根据实际情况调整
         返回：
                我方单元到敌方目标的路径点
        """
    # 设置起点，为当前单元位置
    x = unit['lat']
    y = unit['lon']
    start_pose = np.array([x, y])
    unit_exist = True
    path_dic = []
    # 设置终点，为敌方被打击目标位置(终点只有一个）
    contact_end_point_info = contacts[contact_select_list[0]]

    if len(contact_end_point_info) > 0:
        x = contact_end_point_info['Lat']  # 纬度
        y = contact_end_point_info['Lon']  # 经度
        end_pose = np.array([x, y])

    agent = Dijkstra()
    ratio = ratio
    try:
        if unit_exist:
            ## 构建栅格地图
            dist_x = abs(end_pose[0] - start_pose[0])
            dist_y = abs(end_pose[1] - start_pose[1])
            col_num = int(dist_x / ratio) + 2
            row_num = int(dist_y / ratio) + 2
            map_top_left_x = min(end_pose[0], start_pose[0]) - ratio
            map_top_left_y = max(end_pose[1], start_pose[1]) + ratio
            map_grid = [[1 for j in range(0, col_num)] for i in range(0, row_num)]
            map_grid = np.array(map_grid)

            pos_start_x = int((start_pose[0] - map_top_left_x) / ratio)
            pos_start_y = int((map_top_left_y - start_pose[1]) / ratio)
            pos_end_x = int((end_pose[0] - map_top_left_x) / ratio)
            pos_end_y = int((map_top_left_y - end_pose[1]) / ratio)

            ###设置障碍点——敌方实体位置信息
            contact_info = contacts
            obstacle_contact_info = {}
            # 过滤需要屏蔽的障碍物
            ## 过滤打击敌方目标
            ### 飞机避开战斗机，船避开2002，地面设施避开导弹营/地面移动车
            for key, contact in contact_info.items():
                try:
                    if contact == "DELETE" or key in contact_select_list[0]:
                        continue
                except:
                    print("222")
                try:
                    if contact['Type'] == 0:
                        # 敌方情报是飞机 避开战斗机2001/2002
                        if contact['ActType'] == 2001 or contact['ActType'] == 2002:
                            obstacle_contact_info[key] = contact
                    if contact['Type'] == 2:
                        # 敌方情报是船 避开舰船2002
                        if contact['ActCategory'] == 2002:
                            obstacle_contact_info[key] = contact
                    if contact['Type'] == 7 or contact['Type'] == 8:
                        # 敌方情报是地面设施 避开导弹营/地面移动车 5003/5001
                        if contact['ActType'] == 5003 or contact['ActType'] == 5001:
                            obstacle_contact_info[key] = contact
                except:
                    print("111")

            for contact in obstacle_contact_info.values():
                x = contact["Lat"]
                y = contact["Lon"]
                pose_x = int((x - map_top_left_x) / ratio)
                pose_y = int((map_top_left_y - y) / ratio)
                obstacle_width = 1  # 设置障碍物的宽  int型
                if pose_x >= 0 and pose_x < col_num and pose_y >= 0 and pose_y < row_num:
                    pose_x_min = max(0, pose_x - obstacle_width)
                    pose_x_max = min(pose_x + obstacle_width, col_num - 1)
                    pose_y_min = max(0, pose_y - obstacle_width)
                    pose_y_max = min(pose_y + obstacle_width, row_num - 1)
                    map_grid[pose_y_min:pose_y_max, pose_x_min:pose_x_max] = 0
                    # map_grid[pose_y, pose_x] = 0
            ###设置起点   解释：地球上的经度Lon对应x坐标，地球上的纬度Lat对应y坐标
            map_grid[pos_start_y, pos_start_x] = 5
            ###设置终点
            map_grid[pos_end_y, pos_end_x] = 6

            open_list = [
                [pos_end_y, pos_end_x, 0, 0, None, None]]  # 将终点置于open列表中列表中分别有x0,y0坐标,h值,父节点X、Y坐标
            close_list = []

            ####首次搜索
            while map_grid[pos_start_y, pos_start_x] != 4 and open_list != []:
                [open_list, close_list, map_grid] = agent.first_search(open_list, close_list,
                                                                       map_grid)
            # 首次搜索完成，计算实际地图坐标
            first_path = []
            close_list = np.array(close_list)
            if len(close_list) > 1:
                list1 = list(close_list[np.where((close_list[:, 0] == pos_start_y)
                                                 & (close_list[:, 1] == pos_start_x))][0])
                if list1 is not None:
                    xn = list1[0]
                    yn = list1[1]
                    while xn != pos_end_y or yn != pos_end_x and list1 is not None:
                        first_path.append(list1)
                        xn = int(list1[4])
                        yn = int(list1[5])
                        list1 = list(
                            close_list[np.where((close_list[:, 0] == xn) & (close_list[:, 1] == yn))][
                                0])

                    first_path.append([pos_end_y, pos_end_x, 0, 0, None, None])

                    course_list = list()

                    for point in first_path:
                        course_x = point[1] * ratio + map_top_left_x
                        course_y = map_top_left_y - point[0] * ratio
                        course_list.append((course_x, course_y))
                    course_list = course_list[:-2]  # 删除终点前2个路径点
                    course_list = course_list[4:]  # 删除起点前4个路径点
                    course_list.append((end_pose[0], end_pose[1]))  # 终点添加到路径
                    path_dic = course_list
                    # 图形显示 可以打断点看规划路径是否满足要求 调试算法时可以查看，但是比赛中建议不查看图像(会拉低运行效率)
                    # max_x = max(pos_start_x, pos_end_x) + 1
                    # max_y = max(pos_start_y, pos_end_y) + 1
                    # agent.draw_effect(map_grid, first_path, max_x, max_y)
                    # print(f"=========={unit['guid']}的路径规划完成==========")
        else:
            print(f"不存在单元{unit['guid']},路径规划失败！！！")
    except:
        print("222")
    return path_dic
